/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.jei;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.network.MessageGridProcessingTransfer;
import com.raoulvdberge.refinedstorage.network.MessageGridTransfer;
import com.raoulvdberge.refinedstorage.util.MessageSplitter;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RecipeTransferHandlerGrid
implements IRecipeTransferHandler {
    public static final long TRANSFER_SCROLL_DELAY_MS = 200L;
    public static long LAST_TRANSFER;

    @Nonnull
    public Class<? extends Container> getContainerClass() {
        return ContainerGrid.class;
    }

    public IRecipeTransferError transferRecipe(@Nonnull Container container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        IGrid grid = ((ContainerGrid)container).getGrid();
        if (!grid.isActive()) {
            return new IRecipeTransferError(){

                @Nonnull
                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.INTERNAL;
                }

                public void showError(@Nonnull Minecraft minecraft, int mouseX, int mouseY, @Nonnull IRecipeLayout recipeLayout, int recipeX, int recipeY) {
                }
            };
        }
        if (doTransfer) {
            LAST_TRANSFER = System.currentTimeMillis();
            if (grid.getGridType() == GridType.PATTERN && !this.isCraftingRecipe(recipeLayout.getRecipeCategory())) {
                ItemStack ingredient;
                LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
                LinkedList<ItemStack> outputs = new LinkedList<ItemStack>();
                LinkedList<FluidStack> fluidInputs = new LinkedList<FluidStack>();
                LinkedList<FluidStack> fluidOutputs = new LinkedList<FluidStack>();
                for (IGuiIngredient guiIngredient : recipeLayout.getItemStacks().getGuiIngredients().values()) {
                    if (guiIngredient == null || guiIngredient.getDisplayedIngredient() == null) continue;
                    ingredient = ((ItemStack)guiIngredient.getDisplayedIngredient()).func_77946_l();
                    if (guiIngredient.isInput()) {
                        inputs.add(ingredient);
                        continue;
                    }
                    outputs.add(ingredient);
                }
                for (IGuiIngredient guiIngredient : recipeLayout.getFluidStacks().getGuiIngredients().values()) {
                    if (guiIngredient == null || guiIngredient.getDisplayedIngredient() == null) continue;
                    ingredient = ((FluidStack)guiIngredient.getDisplayedIngredient()).copy();
                    if (guiIngredient.isInput()) {
                        fluidInputs.add((FluidStack)ingredient);
                        continue;
                    }
                    fluidOutputs.add((FluidStack)ingredient);
                }
                RS.INSTANCE.network.sendToServer((IMessage)new MessageGridProcessingTransfer(inputs, outputs, fluidInputs, fluidOutputs));
            } else {
                MessageSplitter.sendToServer(new MessageGridTransfer(recipeLayout.getItemStacks().getGuiIngredients(), container.field_75151_b.stream().filter(s -> s.field_75224_c instanceof InventoryCrafting).collect(Collectors.toList())));
            }
        }
        return null;
    }

    private boolean isCraftingRecipe(IRecipeCategory<?> recipeCategory) {
        return recipeCategory.getUid().equals("minecraft.crafting");
    }
}

